<?php
/* Registrar Menus
------------------------------------------------------------------- */
function register_my_menus()
{
    register_nav_menus(
        array(
            'header-menu' => __('Header Menu'),
            'extra-menu' => __('Extra Menu'),
            'top-bar-menu' => ('Top Bar Menu'),
            'footer-menu' => ('Footer Menu')
        )
    );
}
add_action('init', 'register_my_menus');




/* Thumbnails
------------------------------------------------------------------- */
add_image_size('thumb-curso-peq', 241, 241, array('center', 'center'));
//add_image_size( 'thumb-noticia-home-pequena', 150, 150, array( 'center', 'center' ) );




/* Custom Exceprt Size
------------------------------------------------------------------- */
function custom_excerpt_length($length) {
    return 14;
}
add_filter('excerpt_length', 'custom_excerpt_length', 999);

// Custom Exceprt Symbol
function new_excerpt_more($more) {
    return '...';
}
add_filter('excerpt_more', 'new_excerpt_more');




/* Remover Admin Bar para Todos Usários menos Adminstrador
------------------------------------------------------------------- */
add_action('after_setup_theme', 'remove_admin_bar');

function remove_admin_bar() {
    //if (!current_user_can('administrator') && !is_admin()) {
    show_admin_bar(false);
    //}
}




/* Widgets - Register New Sidebars
------------------------------------------------------------------- */
if (function_exists('register_sidebar')) {
    register_sidebar(array(
        'name' => 'Footer Left Widgets',
        'id'   => 'footer-left-widgets',
        'description'   => 'These are widgets for the footer left area.',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h4>',
        'after_title'   => '</h4>'
    ));
}

if (function_exists('register_sidebar')) {
    register_sidebar(array(
        'name' => 'Footer Right Widgets',
        'id'   => 'footer-right-widgets',
        'description'   => 'These are widgets for the footer right area.',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h4>',
        'after_title'   => '</h4>'
    ));
}

if (function_exists('register_sidebar')) {
    register_sidebar(array(
        'name' => 'Menu Lateral 1',
        'id'   => 'menu-lateral-1',
        'description'   => 'Widgets para o Menu Institucional.',
        'before_widget' => '<div class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h4>',
        'after_title'   => '</h4>'
    ));
}

if (function_exists('register_sidebar')) {
    register_sidebar(array(
        'name' => 'Menu Lateral 2',
        'id'   => 'menu-lateral-2',
        'description'   => 'Widgets para o Menu dos cursos.',
        'before_widget' => '<div class="col-xs-12" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h4>',
        'after_title'   => '</h4>'
    ));
}




/* Custom Shortcodes para inserir blocos
------------------------------------------------------------------- */
/*add_shortcode('bloco-mapa', function () {
    include_once(__DIR__ . '/inc/bloco-mapa.php');
});*/




/* Register Custom Post Type - Indicadores
------------------------------------------------------------------- */
function custom_post_type() {
    $labels = array(
        'name'                  => 'Indicadores',
        'singular_name'         => 'Indicadores',
        'menu_name'             => 'Indicadores',
        'all_items'             => 'Todos Indicadores',
        'add_new'               => 'Adicionar Novo',
        'add_new_item'          => 'Adicionar Novo Indicadores',
        'edit_item'             => 'Editar Indicadores',
        'new_item'              => 'Novo Indicadores',
        'view_item'             => 'Ver Indicadores',
        'search_items'          => 'Buscar Indicadores',
        'not_found'             => 'Nenhum indicador encontrado',
        'not_found_in_trash'    => 'Nenhum indicador encontrado na Lixeira',
        'parent_item_colon'     => 'Indicador Pai:',
        'menu_icon'             => 'dashicons-admin-page',
    );

    $args = array(
        'labels'                => $labels,
        'public'                => true,
        'hierarchical'          => false,
        'has_archive'           => true,
        'publicly_queryable'    => true,
        'rewrite'               => array('slug' => 'indicador'),
        'supports'              => array('title', 'editor'),
    );

    register_post_type('indicador', $args);
}

// Hook into the 'init' action
add_action('init', 'custom_post_type');

// Customize editor for the 'report' post type
function customize_indicador_editor() {
    //remove_post_type_support('indicador', 'thumbnail'); // Remove thumbnail support
}

// Hook into the 'admin_init' action
add_action('admin_init', 'customize_indicador_editor');




/* Register Custom Taxonomy - ODS (para indicadores)
------------------------------------------------------------------- */
function custom_taxonomy_ods() {
    $labels = array(
        'name'                       => 'ODS',
        'singular_name'              => 'ODS',
        'menu_name'                  => 'ODS',
        'all_items'                  => 'Todos ODS',
        'parent_item'                => 'ODS Pai',
        'parent_item_colon'          => 'ODS Pai:',
        'new_item_name'              => 'Novo Nome do ODS',
        'add_new_item'               => 'Adicionar Novo ODS',
        'edit_item'                  => 'Editar ODS',
        'update_item'                => 'Atualizar ODS',
        'separate_items_with_commas' => 'Separar ODS por vírgula',
        'search_items'               => 'Buscar ODS',
        'add_or_remove_items'        => 'Adicionar ou remover ODS',
        'choose_from_most_used'      => 'Escolha das ODS mais usadas',
    );

    $args = array(
        'labels'            => $labels,
        'public'            => true,
        'hierarchical'      => true,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'ods'),
    );

    register_taxonomy('ods', 'indicador', $args);
}

// Hook into the 'init' action
add_action('init', 'custom_taxonomy_ods');




/* Register Custom Taxonomy - UNGC (para indicadores)
------------------------------------------------------------------- */
function custom_taxonomy_ungc() {
    $labels = array(
        'name'                       => 'UNGC',
        'singular_name'              => 'UNGC',
        'menu_name'                  => 'UNGC',
        'all_items'                  => 'Todos UNGC',
        'parent_item'                => 'UNGC Pai',
        'parent_item_colon'          => 'UNGC Pai:',
        'new_item_name'              => 'Novo Nome do UNGC',
        'add_new_item'               => 'Adicionar Novo UNGC',
        'edit_item'                  => 'Editar UNGC',
        'update_item'                => 'Atualizar UNGC',
        'separate_items_with_commas' => 'Separar UNGC por vírgula',
        'search_items'               => 'Buscar UNGC',
        'add_or_remove_items'        => 'Adicionar ou remover UNGC',
        'choose_from_most_used'      => 'Escolha das UNGC mais usadas',
    );

    $args = array(
        'labels'            => $labels,
        'public'            => true,
        'hierarchical'      => true,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'ungc'),
    );

    register_taxonomy('ungc', 'indicador', $args);
}

// Hook into the 'init' action
add_action('init', 'custom_taxonomy_ungc');




/* Register Custom Taxonomy - Pilares (para indicadores)
------------------------------------------------------------------- */
function custom_taxonomy_pilar() {
    $labels = array(
        'name'                       => 'Pilares',
        'singular_name'              => 'Pilar',
        'menu_name'                  => 'Pilares',
        'all_items'                  => 'Todos Pilares',
        'parent_item'                => 'Pilar Pai',
        'parent_item_colon'          => 'Pilar Pai:',
        'new_item_name'              => 'Novo Nome do Pilar',
        'add_new_item'               => 'Adicionar Novo Pilar',
        'edit_item'                  => 'Editar Pilar',
        'update_item'                => 'Atualizar Pilar',
        'separate_items_with_commas' => 'Separar Pilares por vírgula',
        'search_items'               => 'Buscar Pilares',
        'add_or_remove_items'        => 'Adicionar ou remover Pilares',
        'choose_from_most_used'      => 'Escolha dos Pilares mais usados',
    );

    $args = array(
        'labels'            => $labels,
        'public'            => true,
        'hierarchical'      => true,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'pilar'),
    );

    register_taxonomy('pilar', 'indicador', $args);
}

// Hook into the 'init' action
add_action('init', 'custom_taxonomy_pilar');




/* Register Custom Taxonomy - Temas Materiais (para indicadores)
------------------------------------------------------------------- */
function custom_taxonomy_tema_material() {
    $labels = array(
        'name'                       => 'Temas Materiais',
        'singular_name'              => 'Tema Material',
        'menu_name'                  => 'Temas Materiais',
        'all_items'                  => 'Todos Temas Materiais',
        'parent_item'                => 'Tema Material Pai',
        'parent_item_colon'          => 'Tema Material Pai:',
        'new_item_name'              => 'Novo Nome do Tema Material',
        'add_new_item'               => 'Adicionar Novo Tema Material',
        'edit_item'                  => 'Editar Tema Material',
        'update_item'                => 'Atualizar Tema Material',
        'separate_items_with_commas' => 'Separar Temas Materiais por vírgula',
        'search_items'               => 'Buscar Temas Materiais',
        'add_or_remove_items'        => 'Adicionar ou remover Temas Materiais',
        'choose_from_most_used'      => 'Escolha dos Temas Materiais mais usados',
    );

    $args = array(
        'labels'            => $labels,
        'public'            => true,
        'hierarchical'      => true,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'tema-material'),
    );

    register_taxonomy('tema-material', 'indicador', $args);
}

// Hook into the 'init' action
add_action('init', 'custom_taxonomy_tema_material');




/* Register Custom Taxonomy - GRI (para indicadores)
------------------------------------------------------------------- */
function custom_taxonomy_gri() {
    $labels = array(
        'name'                       => 'GRIs',
        'singular_name'              => 'GRI',
        'menu_name'                  => 'GRI',
        'all_items'                  => 'Todos GRIs',
        'parent_item'                => 'GRI Pai',
        'parent_item_colon'          => 'GRI Pai:',
        'new_item_name'              => 'Novo Nome do GRI',
        'add_new_item'               => 'Adicionar Novo GRI',
        'edit_item'                  => 'Editar GRI',
        'update_item'                => 'Atualizar GRI',
        'separate_items_with_commas' => 'Separar GRIs por vírgula',
        'search_items'               => 'Buscar GRIs',
        'add_or_remove_items'        => 'Adicionar ou remover GRIs',
        'choose_from_most_used'      => 'Escolha dos GRIs mais usados',
    );

    $args = array(
        'labels'            => $labels,
        'public'            => true,
        'hierarchical'      => true,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'gri'),
    );

    register_taxonomy('gri', 'indicador', $args);
}

// Hook into the 'init' action
add_action('init', 'custom_taxonomy_gri');





/* Register Custom Taxonomy - SASB (para indicadores)
------------------------------------------------------------------- */
function custom_taxonomy_sasb() {
    $labels = array(
        'name'                       => 'SASBs',
        'singular_name'              => 'SASB',
        'menu_name'                  => 'SASB',
        'all_items'                  => 'Todos SASBs',
        'parent_item'                => 'SASB Pai',
        'parent_item_colon'          => 'SASB Pai:',
        'new_item_name'              => 'Novo Nome do SASB',
        'add_new_item'               => 'Adicionar Novo SASB',
        'edit_item'                  => 'Editar SASB',
        'update_item'                => 'Atualizar SASB',
        'separate_items_with_commas' => 'Separar SASBs por vírgula',
        'search_items'               => 'Buscar SASBs',
        'add_or_remove_items'        => 'Adicionar ou remover SASBs',
        'choose_from_most_used'      => 'Escolha dos SASBs mais usados',
    );

    $args = array(
        'labels'            => $labels,
        'public'            => true,
        'hierarchical'      => true,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'sasb'),
    );

    register_taxonomy('sasb', 'indicador', $args);
}

// Hook into the 'init' action
add_action('init', 'custom_taxonomy_sasb');




/* Query que vai ser executada no Ajax para exibir os Relatorios
de acordo com a categoria clicada na pagina de Relatorios
------------------------------------------------------------------- */
function load_reports_by_category() {

    $category_slug = $_POST['category_slug'];
    $category_name = $_POST['category_name'];

    $args = array(
        'post_type' => 'report',
        'posts_per_page' => -1,
        'tax_query' => array(
            array(
                'taxonomy' => 'report_cat',
                'field'    => 'slug',
                'terms'    => $category_slug,
            ),
        )
    );

    $query = new WP_Query( $args );

    echo '<div class="sub title">';
        echo '<h2 id="catNome">'.$category_name.'</h2>';
    echo '</div>';

    // Se for da categoria "Food and Agricultural Import Regulations and Standards", 
    // vai exibir uma botao selecao de sub categoria antes
    if ( $category_slug == 'food-and-agricultural-import-regulations-and-standards' ) {
        // echo 'eh a categoria';
        echo '<div class="report-sub-cat">';
            echo '<div class="cta alt"><a href="#" id="btnShowCertificateOnly">Certificate</a></div>';
            echo '<div class="cta "><a href="#" id="btnShowNarrativeOnly">Narrative</a></div>';
        echo '</div>';
    } else {
        //echo 'nao eh';
    }

    if ( $query->have_posts() ) {

        echo '<table class="table reports-table tabela-principal">';

        while ( $query->have_posts() ) {
            $query->the_post(); 

            //$report_ID = get_the_ID();
            $report_title = get_the_title();
            //$report_permalink = get_the_permalink();
            $report_date = get_the_date('d/m/Y');
            //$report_desc = get_the_excerpt();
            if ( has_post_thumbnail() ) {
                $post_bg = get_the_post_thumbnail_url($post_ID, 'medium_large');
            } else {
                $post_bg = get_template_directory_uri().'/img/dummy-post.png';
            }

            if ( get_field('report_file') ) {
                $report_link = get_field('report_file');
            } else {
                $report_link = get_field('report_file_link');
            }
            ?>

            <?php
            // Insere a categoria como classe para 
            // exibir ou nao a categoria quando forem
            // as sub-categorias: "Certificate" e "Narrative"

            //global $post;
            //echo  $post->ID;
            $terms = get_the_terms( $post->ID , 'report_cat' );
            $counter = 0;
            foreach ( $terms as $term ) {
                if ($counter == 0) {
                    $nomeDaCategoria = $term->name;
                }
                $counter++;
            }
            ?>

            <tr class="relatorio-item <?php echo $nomeDaCategoria; ?>">
                <td class="">
                    <span class="report-date"><?php echo $report_date;?> - </span>
                    <span class="report-name">
                        <a href="<?php echo $report_link;?>" target="_blank">
                            <?php echo $report_title;?>
                        </a>
                    </span>
                </td>
            </tr>
                
        <?php
        }
        echo '</table>';
    } else {
        echo 'Nenhum relatório encontrado!';
    }

    die(); // Always end with die() to prevent extra output
}
add_action('wp_ajax_load_reports', 'load_reports_by_category');
add_action('wp_ajax_nopriv_load_reports', 'load_reports_by_category');




/* Funcao para carregar o script do Ajax da funcao acima
------------------------------------------------------------------- */
function enqueue_ajax_scripts() {
    wp_enqueue_script('ajax-scripts', get_template_directory_uri() . '/js/ajax-scripts.js?v=1.0', array('jquery'), null, true);

    // Pass the necessary variables to the script
    wp_localize_script('ajax-scripts', 'ajax_vars', array(
        'ajaxurl' => admin_url('admin-ajax.php'),
    ));
}
add_action('wp_enqueue_scripts', 'enqueue_ajax_scripts');




/* Allow SVG
------------------------------------------------------------------- */
add_filter( 'wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {

    global $wp_version;
    if ( $wp_version !== '4.7.1' ) {
       return $data;
    }
  
    $filetype = wp_check_filetype( $filename, $mimes );
  
    return [
        'ext'             => $filetype['ext'],
        'type'            => $filetype['type'],
        'proper_filename' => $data['proper_filename']
    ];
  
  }, 10, 4 );
  
  function cc_mime_types( $mimes ){
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
  }
  add_filter( 'upload_mimes', 'cc_mime_types' );
  
  function fix_svg() {
    echo '<style type="text/css">
          .attachment-266x266, .thumbnail img {
               width: 100% !important;
               height: auto !important;
          }
          </style>';
  }
  add_action( 'admin_head', 'fix_svg' );